package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestFacility extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		List<Facility> fList = Facility.listAll();
		Assert.assertNotNull(fList);
		Assert.assertTrue(fList.size() > 0);

		Facility fac = Facility.findById(1);
		Assert.assertNotNull(fac);
		Assert.assertEquals(fac.getId(), 1);
		

		Facility fac2 = fList.get(0);
		Assert.assertNotNull(fac2);
		Assert.assertTrue(fac2.getId() > 0);
		
		String facName = fac2.getName();
		Assert.assertNotNull(facName);
		Assert.assertTrue(facName.length() > 0);

		fac = Facility.findByName(facName);
		Assert.assertNotNull(fac);
		Assert.assertEquals(fac, fac2);

	}
}
